const express = require('express');
const app = express();
const { engine } = require('express-handlebars');
const path = require('path');
const request = require('request');
const bodyParser = require('body-parser');
const Handlebars = require('handlebars');


const PORT = process.env.PORT || 8000;

//use body parser middleware
app.use(bodyParser.urlencoded({extended: false}));

//set handlebars middleware
app.engine('handlebars', engine());
app.set('view engine', 'handlebars');
app.set('views', './views');


jdata = '{"name":"John", "age":30, "cars":["Ford", "BMW", "Fiat"]}';

// api key: sk-live-4EWDfev0IMasPUmP3E6VhaqgRZvcjXm2yCO74beM

// Start of Trending Stocks Code
var trendingStocksX='';
const options = {
  method: 'GET',
  url: 'https://stock.indianapi.in/trending',
  headers: {'X-Api-Key': 'sk-live-4EWDfev0IMasPUmP3E6VhaqgRZvcjXm2yCO74beM'}
};

function call_api(finishedAPI){
  request(options, function (error, response, body) {
    if (error) throw new Error(error);
  
    if(response.statusCode==200){
      finishedAPI(body);
    }
    
    //console.log(body);
  });
};


// End of Trending Stocks Code

//set handlebars routes
app.get('/', (req, res) => {
  call_api(function (doneApi){
    res.render('home', {
      stuff: "This is home page content.....",
      pagetitle: "Stocks App",
      jArray: JSON.parse(jdata),
      trendingStocks: JSON.parse(doneApi)
    });
  });
    
});



// Start of Stock Details

Handlebars.registerHelper('findObject', function(arr, key, value) {
  return arr.find(obj => obj[key] === value);
});




function call_stockdetails_api(stockName, finishedAStockDetailsAPI){
  
  const stockdetailsoptions = {
    method: 'GET',
    url: 'https://stock.indianapi.in/stock',
    qs: {name: stockName},
    headers: {'X-Api-Key': 'sk-live-4EWDfev0IMasPUmP3E6VhaqgRZvcjXm2yCO74beM'}
  };

  request(stockdetailsoptions, function (error, response, body) {
    if (error) throw new Error(error);
  
    if(response.statusCode==200){
      finishedAStockDetailsAPI(body);
    }
    
    //console.log(body);
    
  });
};


app.get('/stockdetails', (req, res) => {
  call_stockdetails_api("tata steel",function (doneStockDetailsApi){
    res.render('stockdetails', {
      pagetitle: "Stock Details",
      jArray: JSON.parse(jdata),
      stockDetails: JSON.parse(doneStockDetailsApi)
    });
  });
    
});

app.post('/stockdetails', (req, res) => {
  const stockName = req.body.stock_name
  call_stockdetails_api(stockName, function (doneStockDetailsApi){
    
    res.render('stockdetails', {
      pagetitle: "Stock Details",
      jArray: JSON.parse(jdata),
      stockDetails: JSON.parse(doneStockDetailsApi),
      posted_stuff: stockName
    });
  });
    
});
// End of Stock Details

//about page
app.get('/about', (req, res) => {
    res.render('about', {
        stuff: "This is about page content.....",
        pagetitle: "About Page",
        jArray: JSON.parse(jdata)
    });
});


//set static folder
app.use(express.static(path.join(__dirname, 'public')));


app.listen(PORT, ()=> console.log('server listening on PORT '+PORT));